----------------
title : C++ 레퍼런스 - find_if_not 함수 (<algorithm>)
cat_title : find_if_not
ref_title : find_if_not, std::find_if_not
path : /C++ Reference/algorithm
publish_date : 2019-02-04
----------------

##@ cpp-ref-start

#@ find_if_not

`<algorithm>` 에 정의됨

```cpp-formatted
template <class InputIterator, class UnaryPredicate>
InputIterator find_if_not(InputIterator first, InputIterator last,
                          UnaryPredicate pred);
```

범위 내에 조건을 만족하지 않는 원소를 찾는다.

범위 안 (`first` 부터 `last` 전 까지) 의 원소들 중 조건(`pred`)에 일치하지 않는 원소를 가리키는 반복자를 반환합니다. 만일 일치하는 원소가 없다면 `last` 를 리턴합니다.

조건과 일치하지 않는다는 뜻은 `pred` 에 원소를 인자로 전달하여 호출하였을 때 거짓을 반환한다는 의미 입니다.

### 인자들

* `first, last` : 원소들의 시작과 끝을 가리키는 반복자들. 이 때 확인하는 범위는 `[first, last)` 로 정의됩니다. `first` 가 가리키는 원소는 포함되지만 `last` 가 가리키는 원소는 포함되지 않습니다.
* `pred` : 해당 원소를 인자로 받는 단항 함수로 `bool` 혹은 `bool` 로 변환될 수 있는 타입을 리턴한다. 이 리턴값은, 전달된 원소가 조건을 만족하는지 확인하는 역할을 하며, 전달된 원소를 수정하면 안된다.

### 리턴값

첫 번째로 `pred` 가 거짓을 반환하는 원소를 가리키는 반복자를 리턴한다. 만일 `pred` 가 모든 원소에 대해서 거짓을 반환한다면 `last` 를 리턴한다.

### 구현 예시

```cpp-formatted
template <class InputIterator, class UnaryPredicate>
InputIterator find_if_not(InputIterator first, InputIterator last,
                          UnaryPredicate pred) {
  while (first != last) {
    if (!pred(*first)) return first;
    ++first;
  }
  return last;
}
```

### 실행 예제

```cpp-formatted
// find_if_not example
#include <algorithm>  // std::find_if_not
#include <array>      // std::array
#include <iostream>   // std::cout

int main() {
  std::array<int, 5> foo = {1, 2, 3, 4, 5};

  std::array<int, 5>::iterator it =
    std::find_if_not(foo.begin(), foo.end(), [](int i) { return i % 2; });
  std::cout << "첫 번째 짝수인 원소는 " << *it << '\n';

  return 0;
}
```

실행 결과

```exec
첫 번째 짝수인 원소는 2
```

### 참고 자료

* `find_if` : 범위 안에 원소들 중 **조건**과 일치하는 원소를 찾는다.
* `mismatch` : 두 원소의 나열들 중 첫번째로 일치하지 않는 위치를 찾는다.
* `none_of` : 범위 안에 모든 원소들이 조건을 만족하지 않는지 확인한다.